% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Filters.R
\name{Run_SpliceWiz_Filters}
\alias{Run_SpliceWiz_Filters}
\alias{getDefaultFilters}
\alias{applyFilters}
\alias{runFilter}
\title{Filtering for IR and Alternative Splicing Events}
\usage{
getDefaultFilters()

applyFilters(se, filters = getDefaultFilters())

runFilter(se, filterObj)
}
\arguments{
\item{se}{the \linkS4class{NxtSE} object to filter}

\item{filters}{A vector or list of one or more ASEFilter objects. If left
blank, the SpliceWiz default filters will be used.}

\item{filterObj}{A single \linkS4class{ASEFilter} object.}
}
\value{
For \code{runFilter} and \code{applyFilters}: a vector of type \code{logical},
representing the rows of NxtSE that should be kept.

For \code{getDefaultFilters}: returns a list of default recommended filters
that should be parsed into \code{applyFilters}.
}
\description{
These function implements filtering of alternative splicing events,
based on customisable criteria. See \link{ASEFilter} for details on how to
construct SpliceWiz filters
}
\details{
We highly recommend using the default filters, which are as follows:
\itemize{
\item (1) Depth filter of 20,
\item (2) Participation filter requiring 70\% coverage in IR events.
\item (3) Participation filter requiring 40\% coverage in MXE, SE, A5SS and A3SS
events
(i.e. Included + Excluded isoforms must cover at least 40\% of all junction
events across the given region)
\item (4) Consistency filter requring log difference of 2 (for skipped exon and
mutually exclusive exon events, each junction must comprise at least 1/(2^2)
= 1/4 of all reads associated with each isoform).
For retained introns, the exon-intron overhangs must not differ by 1/4
\item (5) Terminus filter: In alternate first exons, the splice junction must
not be shared with another transcript for which it is not its first
intron. For alternative last exons, the splice junction must not be
shared with another transcript for which it is not its last intron
\item (6) ExclusiveMXE filter: For MXE events, the two alternate
casette exons must not overlap in their genomic regions
\item (7) StrictAltSS filter: For A5SS / A3SS events, the two alternate splice
sites must not be interrupted by an intron
}

In all data-based filters, we require at least 80\% samples (\code{pcTRUE = 80})
to pass this filters from the entire dataset (\code{minCond = -1}).

Threshold depths for Participation filters:

For IR/RI, Participation filter is only applied for IR events
for which the intron depth is above a certain threshold (set by \code{minDepth}).
This avoids the filters running on samples for which there is no IR.

For non-IR ASEs, Participation is only run on events with
splice depth (SpliceOver metric) higher than \code{minDepth}. This avoids filters
running on events with low total participation (i.e., (Inc+Exc)/SpliceOver)

Threshold depths for Consistency filters:
Consistency filters are only applied for events where the sum of
upstream and downstream junction counts surpass a given threshold \code{minDepth}.
This is applied on both included and excluded counts (the latter only
applies to MXE). This avoids consistency filters running on events with
insufficient junction counts (leading to high variance between up/downstream
values).

For an explanation of the various parameters mentioned here, see \link{ASEFilter}
}
\section{Functions}{
\itemize{
\item \code{getDefaultFilters()}: Returns a vector of recommended default
SpliceWiz filters

\item \code{applyFilters()}: Run a vector or list of ASEFilter objects
on a NxtSE object

\item \code{runFilter()}: Run a single filter on a NxtSE object

}}
\examples{
# see ?makeSE on example code of how this object was generated

se <- SpliceWiz_example_NxtSE()

# Get the list of SpliceWiz recommended filters

filters <- getDefaultFilters()

# View a description of what these filters do:

filters

# Filter the NxtSE using the first default filter ("Depth")

se.depthfilter <- se[runFilter(se, filters[[1]]), ]

# Filter the NxtSE using all four default filters

se.defaultFiltered <- se[applyFilters(se, getDefaultFilters()), ]
}
\seealso{
\link{ASEFilter} for details describing how to create and assign settings
to ASEFilter objects.
}
