% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{.sanityCheck}
\alias{.sanityCheck}
\title{Sanity check if one and only file with the specified name pattern exists in
the data download directory, and return the file path to .csv
Used for count matrix and metadata only, as they require unique.}
\usage{
.sanityCheck(tech, filetype, expectfilename, dirName, filepatternvar)
}
\arguments{
\item{tech}{Name of technology. Defined at the beginning of the function. e.g. "CosMx"}

\item{filetype}{File type to do sanity check. e.g. "metadata"}

\item{expectfilename}{Expected file pattern name for this file type. e.g. "metadata_file.csv"}

\item{dirName}{Directory to the data download.}

\item{filepatternvar}{The file pattern variable. e.g. "metaDataPattern"}
}
\value{
a path to a unique file of count matrix or colData.
}
\description{
Sanity check if one and only file with the specified name pattern exists in
the data download directory, and return the file path to .csv
Used for count matrix and metadata only, as they require unique.
}
\examples{
\dontrun{
dir <- system.file(file.path("extdata", "CosMx_small"),
                   package = "SpatialExperimentIO")
countmat_file <- SpatialExperimentIO:::.sanityCheck(tech = "CosMx", 
                              filetype = "count matrix",
                              expectfilename = "`exprMat_file.csv`",
                              dirName = dir,
                              filepatternvar = "exprMat_file.csv")
}
}
\author{
Yixing Estella Dong
}
