% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotLRCircos.R
\name{plot_target_from_sources_circos}
\alias{plot_target_from_sources_circos}
\title{Plot Ligand-Receptor Interactions from Multiple Source to a Single Target Cell Type}
\usage{
plot_target_from_sources_circos(
  lr_interactions_df,
  source_cell_names,
  target_cell_name,
  cell_order = NULL,
  gap_degree_after_sector = 5,
  track_height_molecules = 0.1,
  molecule_label_cex = 0.6,
  cell_label_cex = 0.9,
  link_transparency = 0.5,
  link_connection_rou = 0.7,
  link_arrowhead_type = "triangle",
  link_arrowhead_width = 0.1,
  link_arrowhead_length = 0.1,
  score_color_palette_fun = NULL,
  split_segments_for_links = TRUE,
  link_buffer_fraction = 0.1,
  scale_link_width_by_score = FALSE,
  score_transform_for_width = function(s) s,
  use_individual_molecule_colors = TRUE,
  default_ligand_color = "lightgreen",
  default_receptor_color = "lightblue",
  individual_ligand_palette_generator = NULL,
  individual_receptor_palette_generator = NULL,
  molecule_segment_border_col = NA,
  inter_molecule_segment_gap = 0.1
)
}
\arguments{
\item{lr_interactions_df}{A data.frame with columns: \code{ligand}, \code{receptor},
\code{source_cell_type}, \code{target_cell_type}, \code{score}.}

\item{source_cell_names}{Character vector, names of source cell types to show.}

\item{target_cell_name}{Character, name of the single target cell type.}

\item{cell_order}{Optional character vector for specific cell type ordering.
If NULL, target cell is first, then sources alphabetically.}

\item{gap_degree_after_sector}{Numeric, gap in degrees after each sector. Default is 5.}

\item{track_height_molecules}{Numeric, height of the track for molecule segments. Default is 0.1.}

\item{molecule_label_cex}{Numeric, cex for molecule labels. Default is 0.6.}

\item{cell_label_cex}{Numeric, cex for cell type labels. Default is 0.9.}

\item{link_transparency}{Numeric, alpha for links (0 to 1). Default is 0.5.}

\item{link_connection_rou}{Numeric (0-1) or vector of two for \code{rou} in \code{circos.link}. Default is 0.7.}

\item{link_arrowhead_type}{Character. Type of arrowhead (e.g., "triangle", "big.arrow"). Default is "big.arrow".}

\item{link_arrowhead_width}{Numeric. Width of the arrowhead. Default uses circlize default.}

\item{link_arrowhead_length}{Numeric. Length of the arrowhead. Default uses circlize default.}

\item{score_color_palette_fun}{A function (e.g., from \code{circlize::colorRamp2}) to map scores to colors.}

\item{split_segments_for_links}{Logical. If TRUE, molecule segments are sized by interaction count/score
and links connect to unique sub-segments. Default is TRUE.}

\item{link_buffer_fraction}{Numeric (0 to <0.5). Buffer around each link within its sub-segment.
Applies if \code{split_segments_for_links} is TRUE. Default is 0.1.}

\item{scale_link_width_by_score}{Logical. If TRUE (and \code{split_segments_for_links} is TRUE),
link/sub-segment width is proportional to score. Default is FALSE.}

\item{score_transform_for_width}{Function to transform scores for width scaling. Default is \code{function(s) s}.}

\item{use_individual_molecule_colors}{Logical. If TRUE, each unique ligand/receptor name gets a distinct color.
Default is TRUE.}

\item{default_ligand_color}{Character, color for all ligand segments if \code{use_individual_molecule_colors} is FALSE.
Default is "lightgreen".}

\item{default_receptor_color}{Character, color for all receptor segments if \code{use_individual_molecule_colors} is FALSE.
Default is "lightblue".}

\item{individual_ligand_palette_generator}{Function (takes n, returns n colors) for unique ligands.
Default generates a green palette.}

\item{individual_receptor_palette_generator}{Function (takes n, returns n colors) for unique receptors.
Default generates a blue palette.}

\item{molecule_segment_border_col}{Color for the border of L/R segments. Default \code{NA} (no border).}

\item{inter_molecule_segment_gap}{Numeric, gap between L/R segments on the same track. Default is 0.1.}
}
\value{
Invisibly returns NULL. The function is called for its side effect of creating a plot.
}
\description{
Visualizes ligand-receptor interactions focusing on a single target cell type
and its incoming interactions from a specified set of source cell types. Only
relevant ligands from the source cells and receptors on the target cell are shown.
}
\examples{
\dontrun{
if (requireNamespace("circlize", quietly = TRUE) &&
    requireNamespace("RColorBrewer", quietly = TRUE)) {
  # Use the same test data from previous examples
  test_lr_data <- data.frame(
    ligand = c("LGF1","LGF1","LGF2","LGF3","LGF4","LGF1","LGF5","LGF6","LGF5"),
    receptor = c("REC1","REC2","REC1","REC1","REC5","REC4","REC4","REC6","REC2"),
    source_cell_type = c("CellA","CellA","CellB","CellC","CellA","CellD","CellD","CellE","CellD"),
    target_cell_type = c("CellB","CellC","CellA","CellD","CellD","CellA","CellD","CellF","CellA"),
    score = c(4.0,2.5,3.0,2.2,1.5,1.0,3.5,0.5,2.8),
    stringsAsFactors = FALSE
  )
  # Plot interactions from CellB and CellD converging on CellA
  # plot_target_from_sources_circos(test_lr_data,
  #                             source_cell_names = c("CellB", "CellD"),
  #                             target_cell_name = "CellA")

  # Another example: Interactions from CellA and CellC targeting CellD
  # plot_target_from_sources_circos(test_lr_data,
  #                             source_cell_names = c("CellA", "CellC"),
  #                             target_cell_name = "CellD",
  #                             scale_link_width_by_score = TRUE)
 }
}
}
