% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getSpatialParameters.R
\name{get_spatial_parameters}
\alias{get_spatial_parameters}
\title{Read optimal parameters for spatial kernel density from user input or .json
file}
\usage{
get_spatial_parameters(
  spatialPatterns,
  visiumDir = ".",
  spatialDir = "spatial",
  pattern = "scalefactors_json.json",
  sigma = NULL,
  threshold = 4,
  resolution = c("fullres", "lowres", "hires"),
  ...
)
}
\arguments{
\item{spatialPatterns}{A data frame that contains the spatial coordinates
for each cell type. The column names must include 'x' and 'y' as well as a
set of numbered columns named  'Pattern_1.....N'.}

\item{visiumDir}{A string path specifying the location of the 10xVisium
directory}

\item{spatialDir}{A string path specifying the location of the spatial folder
containing the .json file of the spot characteristics}

\item{pattern}{A string specifying the name of the .json file}

\item{sigma}{A numeric value specifying the width of the kernel density
estimate to be used for smoothing}

\item{threshold}{A numeric value specifying how many standard deviations
above the mean of a null distribution to use an outlier threshold for
identifying 'hotspots'}

\item{resolution}{A string specifying image resolution to be used for spot
diameter. Can take values of "fullres" (default), "lowres" or "hires".}

\item{...}{Arguments passed to methods}
}
\value{
a numeric matrix of sigmaOpts - the optimal width of the gaussian
distribution, and the threshOpt - outlier threshold around the set of spots
for each pattern
}
\description{
This function obtains the width of a spatial kernel density
(sigma) from either the user input or from a scale factors .json file.
The outlier threshold around the set of spots (threshold) for each pattern is
specified  by the user (default is 4).
}
\examples{
library(SpaceMarkers)
# Create test data
cells <- c()
test_num <- 500
for(i in 1:test_num){
    cells[length(cells)+1] <- paste0("cell_",i)
}
spPatterns <- data.frame(barcode = cells,
y = runif(test_num, min=0, max=test_num),
x = runif(test_num, min=0, max=test_num),
Pattern_1 = runif(test_num, min=0, max=1),
Pattern_2 = runif(test_num, min=0, max=1) )
# Call the get_spatial_parameters function with the test data
optParams <- get_spatial_parameters(spPatterns, sigma = 10)

}
