% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hdutils.R
\name{.calc_IM_scores}
\alias{.calc_IM_scores}
\title{Calculate interaction scores for a specific pattern pair}
\usage{
.calc_IM_scores(
  data,
  pat_hotspots,
  influence_hotspots,
  patternpair,
  avoid_confounders = FALSE,
  ...
)
}
\arguments{
\item{data}{A numeric matrix with genes as rows and barcodes as columns.}

\item{pat_hotspots}{A data frame with pattern hotspots, containing columns for x, y, and barcode.}

\item{influence_hotspots}{A data frame with influence hotspots, containing columns for x, y, and barcode.}

\item{patternpair}{A character vector of length 2 specifying the pattern pair to analyze.}

\item{avoid_confounders}{Logical (default=FALSE) indicating whether to avoid confounding effects due to colocalization.}

\item{...}{Additional parameters to pass to lower level functions.}
}
\value{
A data frame with interaction scores for the specified pattern pair.
}
\description{
This function calculates interaction scores for a specific pattern pair
using the \code{ .classify_spots} function to determine the region of each spot.
}
