% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{calculate_lr_scores}
\alias{calculate_lr_scores}
\title{calculate_lr_scores}
\usage{
calculate_lr_scores(
  ligand_scores,
  receptor_scores,
  lr_pairs,
  ligand_test = c("greater", "two.sided"),
  method = c("geometric_mean", "arithmetic_mean"),
  weighted = TRUE
)
}
\arguments{
\item{ligand_scores}{Output from getGeneSetScore for ligands}

\item{receptor_scores}{Output from getGeneSetScore for receptors}

\item{lr_pairs}{Data frame with columns 'ligand' and 'receptor'}

\item{ligand_test}{Character; specifies the type of test for ligand overexpression. Options are "greater" or "two.sided"}

\item{method}{Character; specifies the aggregation method for L-R scores. Options are "
geometric_mean" or "arithmetic_mean"}

\item{weighted}{Logical; if TRUE, L-R scores are weighted by their occurrence in
multiple L-R pairs}
}
\value{
Data frame with L-R scores and p-values
}
\description{
Calculate L-R pair scores using Fisher's method
}
\details{
This function computes L-R pair scores by combining ligand and receptor
overexpression scores using either geometric or arithmetic mean. It can also
weight L-R pairs based on their presence in multiple pairs to reduce bias from
promiscuous ligands or receptors.
}
