% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mainSpaNormSVG.R
\name{topSVGs}
\alias{topSVGs}
\title{Export top SVG results to a data frame}
\usage{
topSVGs(spe, n = 10, fdr = 1)
}
\arguments{
\item{spe}{a SpatialExperiment object with SVG results from SpaNormSVG.}

\item{n}{a numeric, specifying the number of top SVGs to call.}

\item{fdr}{a numeric, specifying the false discovery rate (FDR) threshold for calling SVGs.}
}
\value{
A data frame containing the top SVGs from F-test results including F-statistics, p-values and FDR.
}
\description{
Export top SVG results to a data frame
}
\examples{

library(SpatialExperiment)
library(ggplot2)

data(HumanDLPFC)

HumanDLPFC = SpaNorm(HumanDLPFC, sample.p = 0.05, df.tps = 2, tol = 1e-2)
HumanDLPFC = SpaNormSVG(HumanDLPFC)
topSVGs = topSVGs(HumanDLPFC, n = 10)
}
