% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotCovariates.R
\name{plotCovariate}
\alias{plotCovariate}
\title{Diagnostic plot of predicted expression for a covariate}
\usage{
plotCovariate(spe, covariate = c("biology", "ls", "batch"), ...)
}
\arguments{
\item{spe}{a SpatialExperiment object.}

\item{covariate}{a character, specifying the type of covariate to be plot: "biology" (default), "ls" to plot the library size effect, and "batch" to plot the batch-specific effect.}

\item{...}{additional parameters to be passed to the \link{plotSpatial} function.}
}
\value{
a ggplot2 object
}
\description{
This function can be used to spatially visualise the library size, biology or batch specific effect modelled for each gene.
}
\examples{
library(SpatialExperiment)
library(ggplot2)

data(HumanDLPFC)
\donttest{
HumanDLPFC = SpaNorm(HumanDLPFC, sample.p = 0.05, df.tps = 2, tol = 1e-2)
# plot spatial region annotations
p1 <- plotCovariate(HumanDLPFC, covariate = "biology", colour = ENSG00000075624) +
  scale_colour_viridis_c(option = "F")
p1

p2 <- plotCovariate(HumanDLPFC, covariate = "ls", colour = ENSG00000075624) +
  scale_colour_viridis_c(option = "F")
p2
}

}
