% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mainSpaNormSVG.R
\name{SpaNormSVG}
\alias{SpaNormSVG}
\alias{SpaNormSVG,SpatialExperiment-method}
\title{Model-based spatially variable gene (SVG) calling}
\usage{
SpaNormSVG(spe, backend = c("auto", "cpu", "gpu"), verbose = TRUE)

\S4method{SpaNormSVG}{SpatialExperiment}(spe, backend = c("auto", "cpu", "gpu"), verbose = TRUE)
}
\arguments{
\item{spe}{a SpatialExperiment or Seurat object, with the count data stored in 'counts' or 'data' assays respectively, and a SpaNorm model fit.}

\item{backend}{a character, specifying the backend to use for computations. Options are "auto" (default), "cpu", or "gpu". If "auto", it will use GPU if available, otherwise CPU.}

\item{verbose}{a logical, specifying whether to show update messages (default TRUE).}
}
\value{
a SpatialExperiment or Seurat object with F-statistics, false discovery rates (FDRs). For SpatialExperiment objects, these are stored in the rowData.
}
\description{
Spatially variable gene (SVG) calling using the SpaNorm model.
}
\details{
SpaNorm SVG calling works by using the SpaNorm model fit for data normalisation to perform a likelihood ratio test (LRT). The model used for normalisation is considered to be the full model. A second nested model is fit without the splines representing biology. These nested models are then compared using a LRT to identify genes where the splines representing biology contain strong signal.
}
\examples{

library(SpatialExperiment)
library(ggplot2)

data(HumanDLPFC)

HumanDLPFC = SpaNorm(HumanDLPFC, sample.p = 0.05, df.tps = 2, tol = 1e-2)
HumanDLPFC = SpaNormSVG(HumanDLPFC)
head(rowData(HumanDLPFC))

}
