% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mainSpaNormPCA.R
\name{SpaNormPCA}
\alias{SpaNormPCA}
\alias{SpaNormPCA,SpatialExperiment-method}
\title{GLM-based (SpaNorm) PCA}
\usage{
SpaNormPCA(
  spe,
  nsvgs = 3000,
  ncomponents = 50,
  svg.fdr = 1,
  BSPARAM = bsparam(),
  BPPARAM = SerialParam(),
  residuals = c("deviance", "pearson"),
  name = "PCA"
)

\S4method{SpaNormPCA}{SpatialExperiment}(
  spe,
  nsvgs = 3000,
  ncomponents = 50,
  svg.fdr = 1,
  BSPARAM = bsparam(),
  BPPARAM = SerialParam(),
  residuals = c("deviance", "pearson"),
  name = "PCA"
)
}
\arguments{
\item{spe}{a SpatialExperiment or Seurat object, with the count data stored in 'counts' or 'data' assays respectively, and a SpaNorm model fit.}

\item{nsvgs}{the number of SVGs to use for PCA.}

\item{ncomponents}{the number of components to compute.}

\item{svg.fdr}{the FDR threshold for SVG calling.}

\item{BSPARAM}{a BiocSingularParam object specifying which algorithm should be used to perform the PCA.}

\item{BPPARAM}{a BiocParallelParam object specifying whether the PCA should be parallelized.}

\item{residuals}{the type of residuals to use for PCA. Either "deviance" (default) or "pearson".}

\item{name}{the name of the reducedDim to store the PCA results.}
}
\value{
a SpatialExperiment or Seurat object with PCA results. For SpatialExperiment objects, these are stored in the reducedDims.
}
\description{
GLM-based PCA using the SpaNorm model. The null model is considered to consist of the library size effects, batch effects, and the gene mean. GLM-PCA is approximated by regressing the null model from the data, and performing PCA on the residuals (Pearson or deviance).
}
\details{
SpaNorm PCA works by using the SpaNorm model fit for data normalisation to approximate a GLM-based PCA as described in Townes et al. (Genome Biology, 2019). The model used for normalisation represents the library size effects and the gene mean. Regressing these covariates, we remain with the deviance or Pearson residuals, upon which PCA can be performed to approximate the GLM-PCA.
}
\examples{

library(SpatialExperiment)
library(ggplot2)

data(HumanDLPFC)

HumanDLPFC = SpaNorm(HumanDLPFC, sample.p = 0.05, df.tps = 2, tol = 1e-2)
HumanDLPFC = SpaNormSVG(HumanDLPFC)
HumanDLPFC = SpaNormPCA(HumanDLPFC)
reducedDims(HumanDLPFC)

}
