% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/peakwiseAssociations.R
\name{getTargetGenesPvals}
\alias{getTargetGenesPvals}
\title{Fit Negative binomial distribution to target genes}
\usage{
getTargetGenesPvals(
  associationBy = "distance",
  dist = "negative binomial",
  geneCoordinates = NA,
  sites = NA,
  distance = 50000,
  givenRegions = NA
)
}
\arguments{
\item{associationBy}{either "distance" or "regions"}

\item{dist}{either "negative binomial" or "poisson"}

\item{geneCoordinates}{granges coordinates of genes}

\item{sites}{granges coordinates of sites}

\item{distance}{the maximum distance to associate sites to genes. default 50K}

\item{givenRegions}{user provided granges regions like TADs or loops}
}
\value{
A vector of pvalue distribution for target genes
}
\description{
Get genes and sites coordinates, and associate them by given

distance or given regions (ex. TADs or loops). It tests the

distribution of sites around genes either by poisson or

negative binomial test.
}
\examples{

geneFile=system.file("extdata", "gene_expression.tsv", package="Site2Target")
geneCoords <- Table2Granges(geneFile)

tfFile =system.file("extdata", "MEIS_binding.tsv", package="Site2Target")
TFCoords <- Table2Granges(tfFile)

pvals <- getTargetGenesPvals( geneCoordinates=geneCoords, sites=TFCoords)

}
