% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{Table2Granges}
\alias{Table2Granges}
\title{Take Genomic Ranges from a table file}
\usage{
Table2Granges(
  fileName,
  chrColName = "chr",
  startColName = "start",
  endColName = "end"
)
}
\arguments{
\item{fileName}{A table delimited file}

\item{chrColName}{Chromosomes column name (default: "Chr")}

\item{startColName}{Start column name (default: "start")}

\item{endColName}{End column name (default: "end")}
}
\value{
granges format of given coordinates
}
\description{
Read a table file and derive genomic ranges from user provided

column names.
}
\examples{

geneFile=system.file("extdata", "gene_expression.tsv", package="Site2Target")
grs <- Table2Granges(fileName=geneFile,
                      chrColName="chr",
                       startColName="start",
                       endColName="end")
grs

}
