% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FootprintCharter_footprint_detection.r
\name{DetectFootprints}
\alias{DetectFootprints}
\title{Wrapper to run the function detect.footprint across all clusters computed over a single locus}
\usage{
DetectFootprints(
  MethSM,
  partitioned.molecules,
  TF.length = c(5, 75),
  nucleosome.length = c(120, 1000),
  cytosine.coverage.thr = 5
)
}
\arguments{
\item{MethSM}{sparse MethSM as returned by CallContextMethylation()}

\item{partitioned.molecules}{vector of partition assignments per molecule as returned by cluster::pam()}

\item{TF.length}{vector of two integers for footprint length bounds. Defaults to c(5,75).}

\item{nucleosome.length}{vector of two integers for footprint length bounds. Defaults to c(120,1000).}

\item{cytosine.coverage.thr}{Cytosine coverage threshold for footprint detection. Individual cytosines will be discarded, not whole footprints. Defaults to 5.}
}
\description{
Wrapper to run the function detect.footprint across all clusters computed over a single locus
}
