% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SCSRNet-class.R, R/SCSRNoNet-class.R
\name{infParamSC}
\alias{infParamSC}
\alias{infParamSC,SCSRNet-method}
\alias{infParamSC,SCSRNoNet-method}
\title{Inference parameters accessor}
\usage{
\S4method{infParamSC}{SCSRNet}(x)

\S4method{infParamSC}{SCSRNoNet}(x)
}
\arguments{
\item{x}{SCSRNoNet object.}
}
\value{
infParamSC
}
\description{
Inference parameters accessor

Inference parameters accessor
}
\examples{
print("infParamSC")
data(example_dataset, package = "SingleCellSignalR")
mat <- log1p(data.matrix(example_dataset[, -1])) / log(2)
rownames(mat) <- example_dataset[[1]]
rme <- rowMeans(mat)
mmat <- mat[rme > 0.05, ]
d <- dist(t(mmat))
h <- hclust(d, method = "ward.D")
pop <- paste0("pop_", cutree(h, 5))
scsrcn <- SCSRNet(mat,
    normalize = FALSE, method = "log-only",
    log.transformed = TRUE, populations = pop
)

infParamSC(scsrcn)
data(example_dataset, package = "SingleCellSignalR")
mat <- log1p(data.matrix(example_dataset[, -1])) / log(2)
rownames(mat) <- example_dataset[[1]]
rme <- rowMeans(mat)
mmat <- mat[rme > 0.05, ]
d <- dist(t(mmat))
h <- hclust(d, method = "ward.D")
pop <- paste0("pop_", cutree(h, 5))
scsrcn <- SCSRNoNet(mat,
normalize = FALSE, method = "log-only",
log.transformed = TRUE, populations = pop
)
if(FALSE){
# infer ligand-receptor interactions from the comparison

scsrcn <- performInferences(scsrcn,
    verbose = TRUE, ,
    min.logFC = 1e-10, max.pval = 1)

infParamSC(scsrcn)
} 
}
