% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_context_freq.R
\name{get_context_freq}
\alias{get_context_freq}
\title{Extract occurence of tri-nucleotide contexts}
\usage{
get_context_freq(genome, region = NULL)
}
\arguments{
\item{genome}{a BSgenome object}

\item{region}{a GRanges object, path, URL, connection or BEDFile object.}
}
\value{
matrix containing the frequencies of the trinucleotide contexts
}
\description{
Extracts the frequencies of the tri-nucleotide contexts in a given region 
of the genome. These frequencies are needed to normalize a mutational 
catalogue. The output can be input to normalize().
}
\examples{
gr<-GenomicRanges::GRanges(seqnames=c("chr1"),
          ranges=IRanges::IRanges(start=c(100000),end=c(1000000)),
          strand=c("+"))
get_context_freq(BSgenome.Hsapiens.UCSC.hg19::BSgenome.Hsapiens.UCSC.hg19, gr)
get_context_freq(BSgenome.Hsapiens.UCSC.hg19::BSgenome.Hsapiens.UCSC.hg19)

\dontrun{
get_context_freq(BSgenome.Hsapiens.UCSC.hg19::BSgenome.Hsapiens.UCSC.hg19, 'example.bed')
}

}
