% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_zscore_distribution.R
\name{plot_zscore_distribution}
\alias{plot_zscore_distribution}
\title{Plot distribution Z-score}
\usage{
plot_zscore_distribution(time_point_measure, alpha = 1)
}
\arguments{
\item{time_point_measure}{A list containing the table for each time
point. Each table contains for each barcode
the counts for the treated and control the Log2FC,
Zscore, ZscoreRobust, Day.}

\item{alpha}{A value for the opacity of the plot.
Allowed values are in the range 0 to 1}
}
\value{
return the density plot of the distribution of the Z-score
}
\description{
This function plots the Log2FC Z-score distribution of the
             treated vs control in the different time points.
}
\examples{
object <- get0("object", envir = asNamespace("ScreenR"))

table1 <- compute_metrics(object,
    control = "TRT", treatment = "Time3",
    day = "Time3"
)

table2 <- compute_metrics(object,
    control = "TRT", treatment = "Time4",
    day = "Time4"
)

plot_zscore_distribution(list(table1, table2), alpha = 0.5)
}
