% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_trend.R
\name{plot_trend}
\alias{plot_trend}
\title{Plot the trend hit gene}
\usage{
plot_trend(
  screenR_Object,
  genes,
  group_var,
  alpha = 0.5,
  se = FALSE,
  point_size = 1,
  line_size = 1,
  nrow = 1,
  ncol = 1,
  scales = "free"
)
}
\arguments{
\item{screenR_Object}{The ScreenR object obtained using the
\code{\link{create_screenr_object}}}

\item{genes}{The vector of genes to use}

\item{group_var}{The variable that as to be used to filter the data, for
example the different treatment}

\item{alpha}{A value for the opacity of the plot.
Allowed values are in the range 0 to 1}

\item{se}{A boolean to indicate where or not to plot the standard error}

\item{point_size}{The dimension of each dot}

\item{line_size}{The dimension of the line}

\item{nrow}{The number of rows in case multiple genes are plotted}

\item{ncol}{The number of columns in case multiple genes are plotted}

\item{scales}{The scales to be used in the facette}
}
\value{
The plot of the trend over time for a specific treatment.
}
\description{
This function plot the trend of a gene resulted as hit
}
\examples{
object <- get0("object", envir = asNamespace("ScreenR"))

plot_trend(object, genes = "Gene_42", group_var = c("T1", "T2", "TRT"))

plot_trend(object,
    genes = c("Gene_42", "Gene_100"),
    group_var = c("T1", "T2", "TRT"),
    nrow = 2
)
}
