% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/distribution_mapped_reads.R
\name{plot_mapped_reads_distribution}
\alias{plot_mapped_reads_distribution}
\title{Plot the distribution of the mapped reads}
\usage{
plot_mapped_reads_distribution(
  screenR_Object,
  palette = NULL,
  alpha = 1,
  type = "boxplot"
)
}
\arguments{
\item{screenR_Object}{The ScreenR object obtained using the
\code{\link{create_screenr_object}}.}

\item{palette}{The color vector that as to be used for the plot.}

\item{alpha}{A value for the opacity of the plot.
Allowed values are in the range 0 to 1}

\item{type}{The type of plot. The default is "boxplot" the other option is
"density."}
}
\value{
Return a tibble containing the number of mapped read for each sample
}
\description{
This function creates a boxplot or a densityplot to show the
             distribution of the mapped reads in different samples. This
             function can be used to assess the quality of the samples.
             Samples which show roughly the same distribution have
             good quality.
}
\examples{
object <- get0("object", envir = asNamespace("ScreenR"))

# Boxplot
plot_mapped_reads_distribution(object)

# Density
plot_mapped_reads_distribution(object, type = "density")

plot_mapped_reads_distribution(object, type = "density", alpha = 0.2)

}
\concept{plot}
