% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_mapped_reads.R
\name{plot_mapped_reads}
\alias{plot_mapped_reads}
\title{Plot mapped reads}
\usage{
plot_mapped_reads(
  screenR_Object,
  palette = NULL,
  alpha = 1,
  legende_position = "none"
)
}
\arguments{
\item{screenR_Object}{The ScreenR object obtained using the
\code{\link{create_screenr_object}}}

\item{palette}{A vector of color that as to be used to fill the barplot.}

\item{alpha}{A value for the opacity of the plot.
Allowed values are in the range 0 to 1}

\item{legende_position}{Where to positioning the legend of the plot
("none", "left", "right", "bottom", "top")}
}
\value{
return a ggplot object
}
\description{
This function plots the number of reads mapped for each
             sample. It internally call the \code{\link{count_mapped_reads}}
             function, to compute the number of mapped reads.
}
\examples{
object <- get0("object", envir = asNamespace("ScreenR"))

plot_mapped_reads(object)
}
