% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_mds.R
\name{plot_explained_variance}
\alias{plot_explained_variance}
\title{Plot the explained variance by the PC}
\usage{
plot_explained_variance(
  screenR_Object,
  cumulative = FALSE,
  color = "steelblue"
)
}
\arguments{
\item{screenR_Object}{The ScreenR object obtained using the
\code{\link{create_screenr_object}}}

\item{cumulative}{A boolean value which indicates whether or not to plot
the cumulative variance. The default value is FALSE.}

\item{color}{The color to fill the barplot the default value is steelblue}
}
\value{
The explained variance plot
}
\description{
This function plot the explained variance by the
             Principal Component analysis.
}
\examples{
object <- get0("object", envir = asNamespace("ScreenR"))

plot_explained_variance(object)

# For the cumulative plot
plot_explained_variance(object, cumulative = TRUE)
}
