% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/find_common_hit.R
\name{plot_common_hit}
\alias{plot_common_hit}
\title{Plot common hit}
\usage{
plot_common_hit(
  hit_zscore,
  hit_camera,
  hit_roast,
  alpha = 0.5,
  stroke_size = 0.5,
  set_name_size = 4,
  text_color = "black",
  text_size = 4,
  show_percentage = TRUE,
  title = "",
  color = c("#1B9E77", "#D95F02", "#7570B3"),
  show_elements = TRUE
)
}
\arguments{
\item{hit_zscore}{The list of hits of the \code{\link{find_zscore_hit}}}

\item{hit_camera}{The list of hits of the \code{\link{find_camera_hit}}}

\item{hit_roast}{The list of hits of the \code{\link{find_roast_hit}}}

\item{alpha}{A value for the opacity of the plot.
Allowed values are in the range 0 to 1}

\item{stroke_size}{Stroke size for drawing circles}

\item{set_name_size}{Text size for set names}

\item{text_color}{Text color for intersect contents}

\item{text_size}{Text size for intersect contents}

\item{show_percentage}{Show percentage for each set}

\item{title}{The title to display above the plot}

\item{color}{The three vector color for the venn}

\item{show_elements}{Show set elements instead of count/percentage.}
}
\value{
A vector containing the common hit
}
\description{
This method plot the hits in common among the three methods is
             a wrapper for the \code{\link[ggvenn]{ggvenn}} function.
}
\examples{
hit_zscore <- data.frame(Gene = c("A", "B", "C", "D", "E"))
hit_camera <- data.frame(Gene = c("A", "B", "C", "F", "H", "G"))
hit_roast <- data.frame(Gene = c("A", "L", "N"))
plot_common_hit(hit_zscore, hit_camera, hit_roast)

}
