% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_barcode_trend.R
\name{plot_barcode_trend}
\alias{plot_barcode_trend}
\title{Plot the trend over time of the barcodes}
\usage{
plot_barcode_trend(
  list_data_measure,
  genes,
  n_col = 1,
  size_line = 1,
  color = NULL
)
}
\arguments{
\item{list_data_measure}{A list containing the measure table of the
different time point. Generated using the
compute_metrics function.}

\item{genes}{The vector of genes name.}

\item{n_col}{The number of column to use in the facet wrap.}

\item{size_line}{The thickness of the line.}

\item{color}{The vector of colors. One color for each barcode.}
}
\value{
The trend plot for the genes in input.
}
\description{
Plot the log2FC over time of the barcodes in the different
             time point. This plot is useful to check we efficacy of each
             shRNA. Good shRNAs should have consistent trend trend over time.
}
\examples{
object <- get0("object", envir = asNamespace("ScreenR"))

metrics <- dplyr::bind_rows(
    compute_metrics(object,
        control = "TRT", treatment = "Time3",
        day = "Time3"
    ),
    compute_metrics(object,
        control = "TRT", treatment = "Time4",
        day = "Time4"
    )
)
# Multiple Genes
plot_barcode_trend(metrics,
    genes = c("Gene_1", "Gene_50"),
    n_col = 2
)
# Single Gene
plot_barcode_trend(metrics, genes = "Gene_300")
}
