% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/barcode_lost.R
\name{plot_barcode_lost}
\alias{plot_barcode_lost}
\title{Plot number of barcode lost}
\usage{
plot_barcode_lost(
  screenR_Object,
  palette = NULL,
  alpha = 1,
  legende_position = "none"
)
}
\arguments{
\item{screenR_Object}{The ScreenR object obtained using the
\code{\link{create_screenr_object}}}

\item{palette}{A vector of colors to be used to fill the barplot.}

\item{alpha}{A value for the opacity of the plot.
Allowed values are in the range 0 to 1}

\item{legende_position}{Where to positioning the legend of the plot.
Allowed values are in the "top", "bottom", "right",
"left", "none".}
}
\value{
Returns the plot displaying the number of barcode lost in each
        sample
}
\description{
This function plots the number of barcode lost in each sample.
             Usually lots of barcodes lost mean that the sample has low
             quality.
}
\examples{
object <- get0("object", envir = asNamespace("ScreenR"))

plot_barcode_lost(object)
}
\concept{plot}
