% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_barcode_hit.R
\name{plot_barcode_hit}
\alias{plot_barcode_hit}
\title{Plot barcode hit}
\usage{
plot_barcode_hit(
  screenR_Object,
  matrix_model,
  contrast,
  number_barcode = 3,
  gene,
  quantile = c(-0.5, 0.5),
  labels = c("Negative logFC", "Positive logFC")
)
}
\arguments{
\item{screenR_Object}{The ScreenR object obtained using the
\code{\link{create_screenr_object}}}

\item{matrix_model}{The matrix that will be used to perform the
linear model analysis. It is created using
model.matrix.}

\item{contrast}{An object created with \code{\link[limma]{makeContrasts}}
function.}

\item{number_barcode}{Number of barcode that as to be differentially
expressed (DE) in order to consider the associated gene
DE. Example a gene is associated with 10 shRNA we
consider a gene DE if it has at least
number_barcode = 5 shRNA DE.}

\item{gene}{The name of the gene that has to be plot}

\item{quantile}{Quantile to display on the plot}

\item{labels}{The label to be displayed on the quantile side}
}
\value{
The barcode plot
}
\description{
Create a barcode plot for a hit.
             A barcode plot displays if the hit is differentially up or
             down regulated. If most of the vertical line are on the left
             side the gene associated to the barcodes is down regulated
             otherwise is up regulated.
}
\examples{
object <- get0("object", envir = asNamespace("ScreenR"))
matrix_model <- model.matrix(~ slot(object, "groups"))
colnames(matrix_model) <- c("Control", "T1_T2", "Treated")
contrast <- limma::makeContrasts(Treated - Control, levels = matrix_model)

plot_barcode_hit(object, matrix_model,
    contrast = contrast,
    gene = "Gene_300"
)
}
\concept{plot}
