% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generics.R, R/screenr-class.R
\docType{class}
\name{get_count_table}
\alias{get_count_table}
\alias{screenr_object-class}
\alias{screenr_object}
\alias{get_count_table,screenr_object-method}
\alias{get_count_table,screenr_object}
\title{Get ScreenR count table}
\usage{
get_count_table(object)

\S4method{get_count_table}{screenr_object}(object)
}
\arguments{
\item{object}{The ScreenR object obtained using the
\code{\link{create_screenr_object}}}
}
\value{
The count table of the ScreenR object
}
\description{
Get function for the count table of the ScreenR object
}
\section{Slots}{

\describe{
\item{\code{count_table}}{It is used to store the count table to perform the
analysis}

\item{\code{annotation_table}}{It is used to store the annotation of the shRNA}

\item{\code{groups}}{It is used to store the vector of treated and untreated}

\item{\code{replicates}}{It is used to store information about the replicates}

\item{\code{normalized_count_table}}{It is used to store a normalized version of
the count table}

\item{\code{data_table}}{It is used to store a tidy format of the count table}
}}

\examples{
object <- get0("object", envir = asNamespace("ScreenR"))
count_table <- get_count_table(object)
head(count_table)
data("count_table", package = "ScreenR")
data("annotation_table", package = "ScreenR")

groups <- factor(c(
    "T1/T2", "T1/T2", "Treated", "Treated", "Treated",
    "Control", "Control", "Control", "Treated", "Treated",
    "Treated", "Control", "Control", "Control"
))

obj <- create_screenr_object(
    table = count_table,
    annotation = annotation_table,
    groups = groups,
    replicates = c("")
)
}
\concept{objects}
