% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/find_roast_hit.R
\name{find_roast_hit}
\alias{find_roast_hit}
\title{Find Roast Hit}
\usage{
find_roast_hit(
  screenR_Object,
  matrix_model,
  contrast,
  nrot = 9999,
  number_barcode = 3,
  direction = "Down",
  p_val = 0.05
)
}
\arguments{
\item{screenR_Object}{The ScreenR object obtained using the
\code{\link{create_screenr_object}}}

\item{matrix_model}{The matrix that will be used to perform the
linear model analysis. Created using
\code{\link[stats]{model.matrix}}}

\item{contrast}{A vector or a single value indicating the index or the name
of the column the model_matrix to which perform the analysis}

\item{nrot}{Number of rotation to perform the test.
Higher number of rotation leads to more statistically significant
result.}

\item{number_barcode}{Number of barcode that as to be differentially
expressed (DE)in order to consider the gene associated
DE. Example a gene is associated
with 10 shRNA we consider a gene DE if it has at least
number_barcode = 5 shRNA DE.}

\item{direction}{Direction of variation}

\item{p_val}{The value that as to be used as p-value cut off}
}
\value{
The hits found by ROAST method
}
\description{
Find the hit using the roast method. Roast is a competitive gene
             set test which uses rotation instead of permutation. Here is
             applied in a contest of a genetic screening so it perform a
             barcode competitive test testing for barcode which are
             differentially expressed within a gene. More information can be
             found in
          \href{https://www.ncbi.nlm.nih.gov/pmc/articles/PMC2922896/}{Roast}
}
\examples{
set.seed(42)
object <- get0("object", envir = asNamespace("ScreenR"))
matrix_model <- model.matrix(~ slot(object, "groups"))
colnames(matrix_model) <- c("Control", "T1_T2", "Treated")

result <- find_roast_hit(object,
    matrix_model = matrix_model,
    contrast = "Treated", nrot = 100
)
head(result)
}
\concept{find}
