% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/find_common_hit.R
\name{find_common_hit}
\alias{find_common_hit}
\title{Find common hit}
\usage{
find_common_hit(hit_zscore, hit_camera, hit_roast, common_in = 3)
}
\arguments{
\item{hit_zscore}{The matrix obtained by the \code{\link{find_zscore_hit}}
method}

\item{hit_camera}{The matrix obtained by the \code{\link{find_camera_hit}}
method}

\item{hit_roast}{The matrix obtained by the \code{\link{find_roast_hit}}
method}

\item{common_in}{Number of methods in which the hit has to be in common
in order to be considered a candidate hit.
The default value is 3, which means that has to be present
in the result of all the three methods.}
}
\value{
A vector containing the common hit
}
\description{
This method find the hit in common between the three methods
}
\examples{
hit_zscore <- data.frame(Gene = c("A", "B", "C", "D", "E"))
hit_camera <- data.frame(Gene = c("A", "B", "C", "F", "H", "G"))
hit_roast <- data.frame(Gene = c("A", "L", "N"))

# common among all the three methods
find_common_hit(hit_zscore, hit_camera, hit_roast)

# common among at least two of the three methods
find_common_hit(hit_zscore, hit_camera, hit_roast, common_in = 2)
}
\concept{find}
