% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/filter_by.R
\name{filter_by_slope}
\alias{filter_by_slope}
\title{Filter using the slope filter}
\usage{
filter_by_slope(
  screenR_Object,
  genes,
  group_var_treatment,
  group_var_control,
  slope_control,
  slope_treatment
)
}
\arguments{
\item{screenR_Object}{The ScreenR object obtained using the
\code{\link{create_screenr_object}}}

\item{genes}{The genes for which the slope as to be computed. Those genes
are the result of the three statistical methods selection}

\item{group_var_treatment}{The variable to use as independent variable (x)
for the linear model of the treatment}

\item{group_var_control}{The variable to use as independent variable (x)
for the linear model of the the control}

\item{slope_control}{A value used as threshold for the control slope}

\item{slope_treatment}{A value used as threshold for the treatment slope}
}
\value{
A data frame with the slope for the treatment and the control
        for each gene
}
\description{
This function is used to improve the quality of the hits found.
             It computes a regression line in the different samples ad uses
             the slope of this line to see the trend
}
\examples{
object <- get0("object", envir = asNamespace("ScreenR"))

filter_by_slope(
    screenR_Object = object, genes = c("Gene_1", "Gene_2"),
    group_var_treatment = c("T1", "T2", "TRT"),
    group_var_control = c("T1", "T2", "Time3", "Time4"),
    slope_control = 0.5, slope_treatment = 1
)

}
\concept{filter}
