% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/camera_method.R
\name{compute_camera}
\alias{compute_camera}
\title{Compute Camera}
\usage{
compute_camera(
  xglm,
  lrt,
  DGEList,
  matrix_model,
  contrast,
  number_barcode = 3,
  thresh = 1e-04,
  lfc = 1
)
}
\arguments{
\item{xglm}{object created with \code{\link[edgeR]{estimateDisp}}}

\item{lrt}{object created with \code{\link[edgeR]{glmFit}}}

\item{DGEList}{edgeR object}

\item{...}{
  Arguments passed on to \code{\link[=find_camera_hit]{find_camera_hit}}
  \describe{
    \item{\code{matrix_model}}{The matrix that will be used to perform the
linear model analysis created using
\code{\link[stats]{model.matrix}}}
    \item{\code{thresh}}{The threshold for the False Discovery Rate (FDR) that has to be
used to select the statistically significant hits.}
    \item{\code{lfc}}{The Log2FC threshold.}
    \item{\code{number_barcode}}{Number of barcode that as to be differentially
expressed (DE)in order to consider the gene associated
DE. Example a gene is associated
with 10 shRNA we consider a gene DE if it has at least
number_barcode = 5 shRNA DE.}
  }}
}
\value{
The list of hits found by the camera method
}
\description{
This internal function computes the actual hits using  the
             camera method.
}
\keyword{internal}
