% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/filter_mscore_condition.R
\name{filter_mscore_condition}
\alias{filter_mscore_condition}
\title{Filter OpenSWATH output table according to mscore and conditions.}
\usage{
filter_mscore_condition(
  data,
  mscore,
  n_replica,
  peptide_col = c("Peptide.Sequence", "FullPeptideName"),
  charge_col = "Charge",
  condition_col = "Condition",
  rm.decoy = TRUE,
  mscore.col = "m_score"
)
}
\arguments{
\item{data}{A data frame containing SWATH data.}

\item{mscore}{Value that defines the mscore threshold according to which the
data will be filtered.}

\item{n_replica}{Number of measurements within at least one condition that
have to pass the mscore threshold for this transition.}

\item{peptide_col}{Column with peptide identifiers. Default: Peptide.Sequence or FullPeptideName}

\item{charge_col}{Column with peptide charge. Default: Charge}

\item{condition_col}{Column with conditions. Default: Condition}

\item{rm.decoy}{Option to drop decoys from the data}

\item{mscore.col}{Defines the column from which to retrieve the m_score. 
If you use JPP (Rosenberger, Bludau et al. 2017) this can be used to 
select between Protein and transition_group m_score.}
}
\value{
Data which has been filtered.
}
\description{
This function filters the SWATH data according to the m_score value, as well
as to the number of occurence in the data (requant) and within a condition
(condition).
}
\examples{
{
 data("OpenSWATH_data", package="SWATH2stats")
 data("Study_design", package="SWATH2stats")
 data <- sample_annotation(OpenSWATH_data, Study_design)
 data.filtered <- filter_mscore(data, 0.01)
 data.filtered <- filter_mscore_freqobs(data, 0.01, 0.8)
 data.filtered <- filter_mscore_condition(data, 0.01, 3)
 }
}
\author{
Peter Blattmann
}
