% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/count_analytes.R
\name{count_analytes}
\alias{count_analytes}
\title{Counts the analytes across the different injections}
\usage{
count_analytes(
  data,
  column_levels = c("transition_group_id", "FullPeptideName", "ProteinName"),
  column_by = "run_id",
  rm_decoy = TRUE
)
}
\arguments{
\item{data}{A data frame containing SWATH data.}

\item{column_levels}{Columns in which the number of unique identifiers 
should be counted.}

\item{column_by}{Column for which the different identifiers should be counted
for, e.g. for the different injections.}

\item{rm_decoy}{Option to not remove decoy before counting.}
}
\value{
Returns a data frame with the count of the different identifiers per
  e.g. injection.
}
\description{
This functions counts the number of different peakgroups, peptides and
proteins in different injections.
}
\examples{
{
 data("OpenSWATH_data", package="SWATH2stats")
 data("Study_design", package="SWATH2stats")
 data <- sample_annotation(OpenSWATH_data, Study_design)
 counts <- count_analytes(data)
 }
}
\author{
Peter Blattmann
}
