
<!-- README.md is generated from README.Rmd. Please edit that file -->

# SWATH2stats

This package is intended to transform extracted SWATH/DIA data from the
OpenSWATH or other (e.g. Spectronaut) software into a format
directly-usable by statistics packages (e.g. mapDIA, PECA, MSstats)
while performing filtering, annotation and FDR assessment if necessary.

## Analyzing SWATH/DIA data

How to extract SWATH/DIA data before using SWATH2stats with OpenSWATH
can be found here: <http://openswath.org>

## Usage

SWATH2stats is a Bioconductor package. Go to
<https://www.bioconductor.org/packages/release/bioc/html/SWATH2stats.html>
to see all information related to installation. Importantly there exists
both a release and development version.

## Contribution

Please feel free to comment and post issues or pull requests on github.

## Publication

For the publication describing this package, see:
<https://doi.org/10.1371/journal.pone.0153160>

## References

  - Blattmann P, Heusel M, Aebersold R. SWATH2stats: An R/Bioconductor
    Package to Process and Convert Quantitative SWATH-MS Proteomics Data
    for Downstream Analysis Tools. PLoS ONE 11(4): e0153160 (2016). doi:
    10.1371/journal.pone.0153160.

  - Rost HL, Rosenberger G, Navarro P, Gillet L, Miladinovic SM,
    Schubert OT, Wolski W, Collins BC, Malmstrom J, Malmstrom L,
    Aebersold R. OpenSWATH enables automated, targeted analysis of
    data-independent acquisition MS data. Nature Biotechnology. 2014
    Mar;32(3):219-23. doi: 10.1038/nbt.2841.

  - Choi M, Chang CY, Clough T, Broudy D, Killeen T, MacLean B, Vitek O.
    MSstats: an R package for statistical analysis of quantitative mass
    spectrometry-based proteomic experiments.Bioinformatics. 2014 Sep
    1;30(17):2524-6. doi: 10.1093/bioinformatics/btu305.

  - Rosenberger G, Ludwig C, Rost HL, Aebersold R, Malmstrom L. aLFQ: an
    R-package for estimating absolute protein quantities from label-free
    LC-MS/MS proteomics data. Bioinformatics. 2014 Sep 1;30(17):2511-3.
    doi: 10.1093/bioinformatics/btu200.

  - Suomi T., Corthals G., Nevalainen O.S., and Elo L.L. (2015). Using
    Peptide-Level Proteomics Data for Detecting Differentially Expressed
    Proteins. J Proteome Res. Nov 6;14(11):4564-70. doi:
    10.1021/acs.jproteome.5b00363.

  - Suomi, T. and Elo L.L. (2017). Enhanced differential expression
    statistics for data-independent acquisition proteomics" Scientific
    Reports 7, Article number: 5869.doi:10.1038/s41598-017-05949-y
