% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/validate_columns.R
\name{validate_columns}
\alias{validate_columns}
\title{Validate columns for a data.frame}
\usage{
validate_columns(data, columns, verbose = FALSE)
}
\arguments{
\item{data}{data.frame to check for columns.}

\item{columns}{List of column names to be checked if they exist.}

\item{verbose}{Logical if message should be printed. Default = FALSE}
}
\value{
Returns list of columns that are present
}
\description{
This function looks at the different possible column names given and chooses 
the one present in a data.frame. If none of the column names fit or if 
multiple names fit the function stops with an appropriate error  message.
The functions returns a list with the column names existing that can be used.
}
\examples{
{
 validate_columns(cars, list(Speed = c("speed")))
 
 # if out of two possible column one exists
 validate_columns(cars, list(Speed = c("speed", "velocity")))
 validate_columns(cars, list(Speed = c("speed", "velocity")), verbose = TRUE)
 
 }
}
\author{
Peter Blattmann
}
