% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/convert_protein_ids.R
\name{add_genesymbol}
\alias{add_genesymbol}
\title{Adds gene symbols to a table}
\usage{
add_genesymbol(
  data_table,
  gene_ID_table,
  column_name = "Protein",
  ID1 = "uniprotswissprot",
  ID2 = "hgnc_symbol",
  id.separator = "/",
  copy_nonconverted = TRUE
)
}
\arguments{
\item{data_table}{A data frame or file name.}

\item{gene_ID_table}{A table to match gene identifiers against}

\item{column_name}{The column name where the original protein identifiers
are present.}

\item{ID1}{The type of the original protein identifiers
(e.g. "uniprotswissprot", "ensembl_peptide_id").}

\item{ID2}{The type of the converted protein identifiers
(e.g. "hgnc_symbol", "mgi_symbol", "external_gene_name").}

\item{id.separator}{Separator between protein identifiers of shared
peptides.}

\item{copy_nonconverted}{Option defining if the identifiers that cannot be
converted should be copied.}
}
\value{
Returns the data frame with an added column of the converted protein identifiers.
}
\description{
Gather gene symbols from biomart and add them to a data frame.
}
\note{
Protein identifiers from shared peptides should be separated by a forward
slash. The host of archived ensembl databases can be introduced as well
(e.g. "dec2017.archive.ensembl.org")
}
\examples{
{
  gene_ID_table <- data.frame(uniprotswissprot = c("Q01581", "P49327", "P60709"), 
                              hgnc_symbol = c("HMGCS1", "FASN", "ACTB"))
  data_table <- data.frame(Protein = c("Q01581", "P49327", "2/P63261/P60709"), 
                           Abundance = c(100, 3390, 43423))
  add_genesymbol(data_table, gene_ID_table)
  }
}
\author{
Peter Blattmann
}
