% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/STATegRa_omicsPCA_caClass.R
\name{getMethodInfo}
\alias{getMethodInfo}
\alias{getMethodInfo,caClass-method}
\title{Retrieve information about component analysis method}
\usage{
getMethodInfo(x, method=FALSE, comps=NULL, block=NULL)
}
\arguments{
\item{x}{\code{\link{caClass-class}} object.}

\item{method}{Logical indicating whether to return the method name.}

\item{comps}{Character indicating which component number to return ("common", "distinctive" or "all")}

\item{block}{Character indicating the block of data for which the component count will be given. It can be specified by the position of the block ("1" or "2") or the name assigned in the \code{\link{caClass-class}} object. If it is NULL both blocks are displayed.}
}
\value{
A list containing the requested information.
}
\description{
Generic function to retrieve information about the method used by \code{\link{omicsCompAnalysis}} on a \code{\link{caClass-class}} object.
}
\examples{
data("STATegRa_S3")
B1 <- createOmicsExpressionSet(Data=Block1.PCA, pData=ed.PCA,
                               pDataDescr=c("classname"))
B2 <- createOmicsExpressionSet(Data=Block2.PCA,
                               pData=ed.PCA, pDataDescr=c("classname"))
# Omics components analysis
res <- omicsCompAnalysis(Input=list(B1, B2), Names=c("expr", "mirna"),
                         method="DISCOSCA", Rcommon=2, Rspecific=c(2, 2),
                         center=TRUE, scale=TRUE, weight=TRUE)
getMethodInfo(res)
getMethodInfo(res, method=TRUE)
getMethodInfo(res, comps="all", block="expr")
}
\seealso{
\code{\link{omicsCompAnalysis}}, \code{\link{caClass-class}}
}
\author{
Patricia Sebastian-Leon
}
