% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fn_gene_miRNA_regression_models.R
\name{sponge_gene_miRNA_interaction_filter}
\alias{sponge_gene_miRNA_interaction_filter}
\title{Determine miRNA-gene interactions to be considered in SPONGE}
\usage{
sponge_gene_miRNA_interaction_filter(
  gene_expr,
  mir_expr,
  mir_predicted_targets,
  elastic.net = TRUE,
  log.level = "ERROR",
  log.file = NULL,
  var.threshold = NULL,
  F.test = FALSE,
  F.test.p.adj.threshold = 0.05,
  coefficient.threshold = -0.05,
  coefficient.direction = "<",
  select.non.targets = FALSE,
  random_seed = NULL,
  parallel.chunks = 100
)
}
\arguments{
\item{gene_expr}{A gene expression matrix with samples in rows and featurs
in columns. Alternatively an object of class ExpressionSet.}

\item{mir_expr}{A miRNA expression matrix with samples in rows and features
in columns. Alternatively an object of class ExpressionSet.}

\item{mir_predicted_targets}{A data frame with miRNA in cols and genes in rows.
A 0 indicates the miRNA is not predicted to target the gene, >0 otherwise.
If this parameter is NULL all miRNA-gene interactions are tested}

\item{elastic.net}{Whether to apply elastic net regression filtering or not.}

\item{log.level}{One of 'warn', 'error', 'info'}

\item{log.file}{Log file to write to}

\item{var.threshold}{Only consider genes and miRNA with
variance > var.threshold. If this parameter is NULL no variance filtering
is performed.}

\item{F.test}{If true, an F-test is performed on each model parameter to
assess its importance for the model based on the RSS of the full model vs
the RSS of the nested model without the miRNA in question. This is time
consuming and has the potential disadvantage that correlated miRNAs are
removed even though they might play a role in ceRNA interactions. Use at your
own risk.}

\item{F.test.p.adj.threshold}{If F.test is TRUE, threshold to use for
miRNAs to be included.}

\item{coefficient.threshold}{threshold to cross for a regression coefficient
to be called significant. depends on the parameter coefficient.direction.}

\item{coefficient.direction}{If "<", coefficient has to be lower than
coefficient.threshold, if ">", coefficient has to be larger than threshold.
If NULL, the absolute value of the coefficient has to be larger than the
threshold.}

\item{select.non.targets}{For testing effect of miRNA target information.
If TRUE, the method determines as usual which miRNAs are potentially
targeting a gene. However, these are then replaced by a random sample of
non-targeting miRNAs (without seeds) of the same size. Useful for testing
if observed effects are caused by miRNA regulation.}

\item{random_seed}{A random seed to be used for reproducible results}

\item{parallel.chunks}{Split into this number of tasks if parallel processing
is set up. The number should be high enough to guarantee equal distribution
of the work load in parallel execution. However, if the number is too large,
e.g. in the worst case one chunk per computation, the overhead causes more
computing time than can be saved by parallel execution. Register a parallel
backend that is compatible with foreach to use this feature. More information
can be found in the documentation of the foreach / doParallel packages.}
}
\value{
A list of genes, where for each gene, the regulating miRNA are
included as a data frame. For F.test = TRUE this is a data frame with fstat
and p-value for each miRNA. Else it is a data frame with the model
coefficients.
}
\description{
The purpose of this method is to limit the number of miRNA-gene
interactions we need to consider in SPONGE. There are 3 filtering steps:
1. variance filter (optional). Only considre genes and miRNAs with variance >
var.threshold.
2. miRNA target database filter (optional). Use a miRNA target database
provided by the user to filter for those miRNA gene interactions for which
evidence exists. This can either be predicted target interactions or
experimentally validated ones.
3. For each remaining interaction of a gene and its regulating miRNAs
use elastic net regression to achieve
a) Feature selection: We only retain miRNAs that influence gene expression
b) Effect strength: The sign of the coefficients allows
us to filter for miRNAs that down-regulate gene expression. Moreover, we can
use the coefficients to rank the miRNAs by their relative effect strength.
We strongly recommend setting up a parallel backend compatible with the
foreach package. See example and the documentation of the
foreach and doParallel packages.
}
\examples{
#library(doParallel)
#cl <- makePSOCKcluster(2)
#registerDoParallel(cl)
genes_miRNA_candidates <- sponge_gene_miRNA_interaction_filter(
gene_expr = gene_expr,
mir_expr = mir_expr,
mir_predicted_targets = targetscan_symbol)
#stopCluster(cl)

#If we also perform an F-test, only few of the above miRNAs remain
genes_miRNA_candidates <- sponge_gene_miRNA_interaction_filter(
gene_expr = gene_expr,
mir_expr = mir_expr,
mir_predicted_targets = targetscan_symbol,
F.test = TRUE,
F.test.p.adj.threshold = 0.05)

}
\seealso{
sponge
}
