% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fn_significance.R
\name{sponge_compute_p_values}
\alias{sponge_compute_p_values}
\title{Compute p-values for SPONGE interactions}
\usage{
sponge_compute_p_values(sponge_result, null_model, log.level = "ERROR")
}
\arguments{
\item{sponge_result}{A data frame from a sponge call}

\item{null_model}{optional, pre-computed simulated data}

\item{log.level}{The log level of the logging package}
}
\value{
A data frame with sponge results, now including p-values
and adjusted p-value
}
\description{
This method uses pre-computed covariance matrices that were
created for various gene-gene correlations (0.2 to 0.9 in steps of 0.1)
and number of miRNAs (between 1 and 8) under the null hypothesis that the
sensitivity correlation is zero. Datasets are sampled from this null model
and allow for an empirical p-value to be computed that is only significant
if the sensitivity correlation is higher than can be expected by chance
given the number of samples, correlation and number of miRNAs. p-values
are adjusted indepdenently for each parameter
combination using Benjamini-Hochberg FDR correction.
}
\examples{
sponge_compute_p_values(ceRNA_interactions,
null_model = precomputed_null_model)
}
\seealso{
sponge_build_null_model
}
