% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fn_simulation.R
\name{sample_zero_mscor_cov}
\alias{sample_zero_mscor_cov}
\title{Sampling zero multiple miRNA sensitivity covariance matrices}
\usage{
sample_zero_mscor_cov(
  m,
  number_of_solutions,
  number_of_attempts = 1000,
  gene_gene_correlation = NULL,
  random_seed = NULL,
  log.level = "ERROR"
)
}
\arguments{
\item{m}{number of miRNAs, i.e. number of columns of the matrix}

\item{number_of_solutions}{stop after this many instances have been samples}

\item{number_of_attempts}{give up after that many attempts}

\item{gene_gene_correlation}{optional, define the correlation of the first
two elements, i.e. the genes.}

\item{random_seed}{A random seed to be used for reproducible results}

\item{log.level}{the log level, typically set to INFO, set to DEBUG for
verbose logging}
}
\value{
a list of covariance matrices with zero sensitivity correlation
}
\description{
Sampling zero multiple miRNA sensitivity covariance matrices
}
\examples{
sample_zero_mscor_cov(m = 1,
number_of_solutions = 1,
gene_gene_correlation = 0.5)
}
