% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fn_spongeffects_utility.R
\name{prepare_tcga_for_spongEffects}
\alias{prepare_tcga_for_spongEffects}
\title{prepare TCGA formats for spongEffects}
\usage{
prepare_tcga_for_spongEffects(
  tcga_cancer_symbol,
  normal_ceRNA_expression_data,
  tumor_ceRNA_expression_data,
  normal_metadata,
  tumor_metadata,
  clinical_data,
  tumor_stages_of_interest,
  subtypes_of_interest
)
}
\arguments{
\item{tcga_cancer_symbol}{e.g., BRCA for breast cancer}

\item{normal_ceRNA_expression_data}{normal ceRNA expression data
(same structure as input for SPONGE)}

\item{tumor_ceRNA_expression_data}{tumor ceRNA expression data
(same structure as input for SPONGE)}

\item{normal_metadata}{metadata for normal samples
(TCGA format style, needs to include column: sampleID, PATIENT_ID)}

\item{tumor_metadata}{metadata for tumor samples
(TCGA format style, needs to include column: sampleID, PATIENT_ID)}

\item{clinical_data}{clinical data for all patients
(TCGA format style, needs to include column: PATIENT_ID, AJCC_PATHOLOGIC_TUMOR_STAGE)}

\item{tumor_stages_of_interest}{array e.g.,
c(STAGE I', 'STAGE IA', 'STAGE IB', 'STAGE II', 'STAGE IIA')}

\item{subtypes_of_interest}{array e.g.,
c("LumA",  "LumB",  "Her2",  "Basal", "Normal")}
}
\value{
list of prepared data. You can access it with list$objectname for
further spongEffects steps
}
\description{
prepare TCGA formats for spongEffects
}
