% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fn_spongeffects_utility.R
\name{plot_involved_miRNAs_to_modules}
\alias{plot_involved_miRNAs_to_modules}
\title{plots the heatmap of miRNAs invovled in the interactions of the modules
(see Boniolo and Hoffmann 2022 et al. Fig. 7a)}
\usage{
plot_involved_miRNAs_to_modules(
  sponge_modules,
  trained_model,
  gene_mirna_candidates,
  k_modules = 25,
  filter_miRNAs = 3,
  bioMart_gene_symbol_columns = "hgnc_symbol",
  bioMart_gene_ensembl = "hsapiens_gene_ensembl",
  width = 5,
  length = 5,
  show_row_names = T,
  show_column_names = T,
  show_annotation_column = F,
  title = "Frequency",
  legend_height = 1.5,
  labels_gp_fontsize = 8,
  title_gp_fontsize = 8,
  legend_width = 3,
  column_title = "Module",
  row_title = "miRNA",
  row_title_gp_fontsize = 10,
  column_title_gp_fontsize = 10,
  row_names_gp_fontsize = 7,
  column_names_gp_fontsize = 7,
  column_names_rot = 45,
  unit = "cm"
)
}
\arguments{
\item{sponge_modules}{result of define_modules()}

\item{trained_model}{returned from train_and_test_model}

\item{gene_mirna_candidates}{output of SPONGE or SPONGEdb (miRNAs_significance)}

\item{k_modules}{top k modules to be shown (default: 25)}

\item{filter_miRNAs}{min rowsum to be reach of miRNAs (default: 3.0)}

\item{bioMart_gene_symbol_columns}{bioMart dataset column for gene symbols
(e.g. human: hgnc_symbol, mouse: mgi_symbol)
(default: hgnc_symbol)}

\item{bioMart_gene_ensembl}{bioMart gene ensemble name
(e.g., hsapiens_gene_ensembl)}

\item{width}{the width of the heatmap (default: 5)}

\item{length}{the length of the heatmap (default: 5)}

\item{show_row_names}{show row names (default: T)}

\item{show_column_names}{show column names (default: T)}

\item{show_annotation_column}{add annotation column to columns (default: F)}

\item{title}{the title of the plot (default: "Frequency")}

\item{legend_height}{the height of the legend (default: 1.5)}

\item{labels_gp_fontsize}{the font size of the labels (default: 8)}

\item{title_gp_fontsize}{the font size of the title (default: 8)}

\item{legend_width}{the width of the legend (default: 3)}

\item{column_title}{the column title (default: "Module")}

\item{row_title}{the title of the rows (default: "miRNA")}

\item{row_title_gp_fontsize}{the font size of the row title (default: 10)}

\item{column_title_gp_fontsize}{the font size of the column title (default: 10)}

\item{row_names_gp_fontsize}{the font size of the row names (default: 7)}

\item{column_names_gp_fontsize}{the font size of the column names (default: 7)}

\item{column_names_rot}{the rotation angel of the column names (default: 45)}

\item{unit}{either cm or inch (see ComplexHeatmap parameter)}
}
\value{
plot object
}
\description{
plots the heatmap of miRNAs invovled in the interactions of the modules
(see Boniolo and Hoffmann 2022 et al. Fig. 7a)
}
