% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fn_spongeffects_utility.R
\name{get_central_modules}
\alias{get_central_modules}
\title{prepare ceRNA network and network centralities from SPONGE / SPONGEdb}
\usage{
get_central_modules(
  central_nodes,
  node_centrality,
  ceRNA_class = c("lncRNA", "circRNA", "protein_coding"),
  centrality_measure = "Weighted_Degree",
  cutoff = 1000
)
}
\arguments{
\item{central_nodes}{Vector containing Ensemble IDs of the chosen RNAs to use as central nodes for the modules.}

\item{node_centrality}{output from filter_ceRNA_network() or own measurement, if own measurement taken, please provide node_centrality_column}

\item{ceRNA_class}{default c("lncRNA","circRNA","protein_coding") (see http://www.ensembl.org/info/genome/genebuild/biotypes.html)}

\item{centrality_measure}{Type of centrality measure to use. (Default: "Weighted_Degree", calculated in filter_ceRNA_network())}

\item{cutoff}{the top cutoff modules will be returned (default: 1000)}
}
\value{
top cutoff modules, with selected RNAs as central genes
}
\description{
prepare ceRNA network and network centralities from SPONGE / SPONGEdb
}
