% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fn_spongeffects_utility.R
\name{filter_ceRNA_network}
\alias{filter_ceRNA_network}
\title{prepare ceRNA network and network centralities from SPONGE / SPONGEdb
for spongEffects}
\usage{
filter_ceRNA_network(
  sponge_effects,
  Node_Centrality = NA,
  add_weighted_centrality = T,
  mscor.threshold = NA,
  padj.threshold = NA
)
}
\arguments{
\item{sponge_effects}{the ceRNA network downloaded as R object from SPONGEdb
(Hoffmann et al., 2021) or created by SPONGE (List et al., 2019)
(ends with _sponge_results in the SPONGE vignette)}

\item{Node_Centrality}{the network analysis downloaded as R object
from SPONGEdb (Hoffmann et al., 2021) or created by SPONGE and containing centrality measures.
(List et al., 2019) (ends with _networkAnalysis in the SPONGE vignette, you can also use your own network centrality measurements)
if network_analysis is NA then the function only filters the ceRNA network, otherwise it will filter the given network centralities, but will not recalculate them based on the filtered ceRNA network.}

\item{add_weighted_centrality}{calculate and add weighted centrality measures to previously
available centralities. Default = T}

\item{mscor.threshold}{mscor threshold to be filtered (default: NA)}

\item{padj.threshold}{adjusted p-value to be filtered (default: NA)}
}
\value{
list of filtered ceRNA network and network centrailies. You can
access it with list$objectname for further spongEffects steps
}
\description{
prepare ceRNA network and network centralities from SPONGE / SPONGEdb
for spongEffects
}
