% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/crossing_of_crossK.R
\name{crossing_of_crossK}
\alias{crossing_of_crossK}
\title{crossing_of_crossK}
\usage{
crossing_of_crossK(df.cross)
}
\arguments{
\item{df.cross}{Data.frame. The output of
\code{\link{calculate_cross_functions}}. Containing the positions of the
two curves. Columns contain "r", "border" and "theo".}
}
\value{
A number. The percentage of the crossing position of the specified
  distance. Returns NA when the crossing happens too close to the y axis (<4%).
}
\description{
Determine if there is a crossing in the cross K curves, to
  further detect the existence of potential immune rings.
}
\examples{
df_cross <- calculate_cross_functions(SPIAT::defined_image, method="Kcross",
              cell_types_of_interest = c("Tumour","Immune3"),
              feature_colname ="Cell.Type", dist = 100)
crossing_of_crossK(df_cross)
}
