% Generated by roxygen2: do not edit by hand
% Please edit documentation in
%   R/calculate_pairwise_distances_between_celltypes.R
\name{calculate_pairwise_distances_between_celltypes}
\alias{calculate_pairwise_distances_between_celltypes}
\title{calculate_pairwise_distances_between_celltypes}
\usage{
calculate_pairwise_distances_between_celltypes(
  spe_object,
  cell_types_of_interest = NULL,
  feature_colname
)
}
\arguments{
\item{spe_object}{SpatialExperiment object in the form of the output of
\code{\link{format_image_to_spe}}.}

\item{cell_types_of_interest}{String Vector containing cell types to be
considered, if NULL, all cell type combinations will be calculated.}

\item{feature_colname}{String of the name the feature column with the cell
types of interest to be considered.}
}
\value{
A data.frame is returned.
}
\description{
Returns the pairwise distances between cells of different types.
  If none of the cell types are found, it will print an error message and
  return a vector of NAs.
}
\examples{
calculate_pairwise_distances_between_celltypes(SPIAT::defined_image,
cell_types_of_interest = c("Tumour","Immune1"), 
feature_colname = "Cell.Type")
}
