% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calculate_cross_functions.R
\name{calculate_cross_functions}
\alias{calculate_cross_functions}
\title{calculate_cross_functions}
\usage{
calculate_cross_functions(
  spe_object,
  method = "Kcross",
  cell_types_of_interest,
  feature_colname,
  plot_results = TRUE,
  dist = NULL
)
}
\arguments{
\item{spe_object}{SpatialExperiment object in the form of the output of
\code{\link{format_image_to_spe}}.}

\item{method}{String that is the method for dependence calculation. Options:
"Gcross", "Kcross", "Kcross.inhom", "Lcross", "Jcross". Default method is
"Kcross".}

\item{cell_types_of_interest}{String Vector. Cell types of interest.}

\item{feature_colname}{String that is the name of the column of the types.}

\item{plot_results}{Boolean. TRUE if result to be plotted, FALSE if not. In
either case, an object with the results is returned}

\item{dist}{Number (OPTIONAL) The largest distance between two cell types at
which K function is evaluated. If NULL, use the default distances set by
cross functions.}
}
\value{
An object of class "fv" defined in `spatstat` package.
}
\description{
Compute and plot the cross functions between two specified cell
  types. This function implements the cross functions from [spatstat] package.
}
\examples{
df_cross <- calculate_cross_functions(SPIAT::defined_image, 
method = "Kcross", cell_types_of_interest = c("Tumour","Immune3"),
feature_colname ="Cell.Type", dist = 100)
}
