% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{splitDataByDensity}
\alias{splitDataByDensity}
\title{Split methylation data into regions based on the density of CpGs}
\usage{
splitDataByDensity(
  dat,
  window.size = 100,
  by = 1,
  min.density = 5,
  gap = 10,
  min.cpgs = 50,
  max.cpgs = 2000,
  verbose = TRUE
)
}
\arguments{
\item{dat}{a data frame with rows as individual CpGs appearing
in all the samples. The first 4 columns should contain the information of
\code{Meth_Counts} (methylated counts), \code{Total_Counts} (read depths),
\code{Position} (Genomic position for the CpG site) and \code{ID} (sample ID).
The covariate information, such as disease status or cell type composition,
are listed in column 5 and onwards.}

\item{window.size}{this positive integer defines the size of the
sliding window in bp. Decimal values will be rounded to the nearest integer.
The value should be greater than 10. The default value is \code{100} (100 bp)}

\item{by}{positive integer defines by how many base pairs the
window moves at each increment. Decimal values will be rounded to the
nearest integer. The default value is \code{1} (1 bp).}

\item{min.density}{positive integer defines the minimum density
threshold for each window. Decimal values will be rounded to the
nearest integer. The default value is \code{5} (5 CpGs/\code{window.size}).}

\item{gap}{positive integer defining the gap width
beyond which we consider that two regions are independent.
Decimal values will be rounded to the nearest integer.
The default value is \code{10} (10bp).}

\item{min.cpgs}{positive integer defining the minimum number of
CpGs within a region for the algorithm to perform optimally.
The default value is 50.}

\item{max.cpgs}{positive integer defining the maximum number of
CpGs within a region for the algorithm to perform optimally.
The default value is 2000.}

\item{verbose}{logical indicates if the algorithm should provide progress
report information. The default value is TRUE.}
}
\value{
A named \code{list} of \code{data.frame} containing the data of each
independent region.
}
\description{
This function splits the methylation data into regions
based on the density of CpGs.
}
\examples{
#------------------------------------------------------------#
data(RAdat)
RAdat.f <- na.omit(RAdat[RAdat$Total_Counts != 0, ])
results <- splitDataByDensity(dat = RAdat.f, window.size = 100, by = 1, 
min.density = 5, gap = 10, min.cpgs = 50, verbose = FALSE)
}
\author{
Audrey Lemaçon
}
