% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/visualize.R
\name{plotAndSummarizeAllelicBiasTest}
\alias{plotAndSummarizeAllelicBiasTest}
\title{Summarize the allelic bias analysis across SNP regions and bins and visualize some of the results.}
\usage{
plotAndSummarizeAllelicBiasTest(SNPhood.o, signThreshold = 0.05,
  fileToPlot = NULL)
}
\arguments{
\item{SNPhood.o}{Object of class \code{\linkS4class{SNPhood}}}

\item{signThreshold}{Numeric(1). Default 0.05. The significance threshold (such as p-value or FDR threshold). Must be between 0 and 1. If the parameter belongs to a plotting function, a horizontal line is drawn at the chosen value. For the allelic bias summary plots, p-values below this threshold and the corresponding allelic fractions are highlighted.}

\item{fileToPlot}{Character(1) or \code{NULL}. Default \code{NULL}. 
Filename of the PDF file for the output plots.
If set to \code{NULL}, plots will be plotted to the currently active device.}
}
\value{
A named list with various elements, each of which summarizes the allelic bias tests with a different focus. TODO
}
\description{
\code{plotAndSummarizeAllelicBiasTest} summarizes the allelic bias test across SNP regions and bins by calculating various summary statistics. 
See the Vignette for more details. TODO
}
\examples{
data(SNPhood, package="SNPhood")
SNPhood.o = testForAllelicBiases (SNPhood.o, readGroups = c("maternal", "paternal"))
SNPhood.o = plotAndSummarizeAllelicBiasTest(SNPhood.o)
}

