% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/visualize.R
\name{plotAndCalculateCorrelationDatasets}
\alias{plotAndCalculateCorrelationDatasets}
\title{Calculate and plot correlation of region read counts among pairs of input files.}
\usage{
plotAndCalculateCorrelationDatasets(SNPhood.o, fileToPlot = NULL,
  corMeasure = "pearson", verbose = FALSE, ...)
}
\arguments{
\item{SNPhood.o}{Object of class \code{\linkS4class{SNPhood}}}

\item{fileToPlot}{Character(1) or \code{NULL}. Default \code{NULL}. 
Filename of the PDF file for the output plots.
If set to \code{NULL}, plots will be plotted to the currently active device.}

\item{corMeasure}{Character(1). Default "pearson". The correlation measure that should be used to compare between pairs of samples. 
Either \code{pearson}, \code{spearman}, or \code{kendall}.}

\item{verbose}{Logical(1). Default FALSE. Should the verbose mode (i.e., diagnostic messages during execution of the script) be enabled?}

\item{...}{Additional arguments for the \code{corrplot.mixed} function from the \code{corrplot} package (if available).}
}
\value{
An object of type \code{SNPhood}, with the results of the correlation analysis stored in the slot "additionalResults".
They can be retrieved via the helper function \code{results} for further investigation.
The results consist of a named list with two elements: A correlation matrix of the region read counts across all input files and a 
translation table to correlate the input files with the abbreviations from the correlation plot.
}
\description{
\code{plotAndCalculateCorrelationDatasets} calculates and plots the pairwise correlation of all pairs of input files with among each other. 
The main purpose is to identify artefacts with particular files that should subsequently be excluded.
The correlation is based on the raw region read counts(i.e., before binning). 
The results of the correlation analysis are stored in the \code{\linkS4class{SNPhood}} object.
If the \code{corrplot} package is available, it will be used to produce a nice visualization of the correlation matrix.
}
\examples{
data(SNPhood.o, package="SNPhood")
# Plot directly, using Pearson correlation
SNPhood.o = plotAndCalculateCorrelationDatasets(SNPhood.o)
# Plot to a PDF file
SNPhood.o = plotAndCalculateCorrelationDatasets(SNPhood.o, fileToPlot = "res.pdf")
# Using Spearman correlation instead of Pearson
SNPhood.o = plotAndCalculateCorrelationDatasets(SNPhood.o, corMeasure = "spearman")
}

