% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/core.R
\name{deleteRegions}
\alias{deleteRegions}
\title{Delete a set of user regions from a \emph{SNPhood} object.}
\usage{
deleteRegions(SNPhood.o, regions, verbose = TRUE)
}
\arguments{
\item{SNPhood.o}{Object of class \code{\linkS4class{SNPhood}}}

\item{regions}{Numeric or Character or NULL. Default NULL. Regions that should be plotted, either specified as integer (such as 1, value must be
between 1 and the total number of regions as defined in the object) or their annotation (name must appear in the region names as obtained via the function \code{annotationRegions}). If set to NULL, all regions will be considered.}

\item{verbose}{Logical(1). Default TRUE. Should the verbose mode (i.e., diagnostic messages during execution of the script) be enabled?}
}
\value{
an object of class \code{\link{SNPhood}} with the requested regions being deleted.
}
\description{
\code{deleteRegions} deletes a set of user regions. 
Removal is irreversible. It is therefore recommended to save the resulting \code{\link{SNPhood}} object with a new name.
}
\section{Warning}{
 
\strong{Execution of this function resets the slot additionalResults and all of its results (e.g, allelic bias analysis).
The reason for this is that all results stored in this slot are affected by the deletion of regions}
}
\examples{
data(SNPhood.o, package="SNPhood")
# Delete the first 10 regions
SNPhood_mod.o = deleteRegions(SNPhood.o, c(1:10))

# Delete regions by their annotation
SNPhood_mod.o = deleteRegions(SNPhood.o, c("rs2822405", "rs467140"))
}
\seealso{
\code{\link{deleteDatasets}}, \code{\link{deleteReadGroups}}
}

