% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/core.R
\name{deleteReadGroups}
\alias{deleteReadGroups}
\title{Delete a particular set of read groups.}
\usage{
deleteReadGroups(SNPhood.o, readGroups = NULL, verbose = TRUE)
}
\arguments{
\item{SNPhood.o}{Object of class \code{\linkS4class{SNPhood}}}

\item{readGroups}{Character or NULL. Default NULL. Read groups that should be plotted, specified by their name as obtained by the function \code{annotationReadGroups}). If set to NULL, all read groups will be considered.}

\item{verbose}{Logical(1). Default TRUE. Should the verbose mode (i.e., diagnostic messages during execution of the script) be enabled?}
}
\value{
an object of class \code{\link{SNPhood}} with read counts across read groups (both for the slots readCountsUnbinned and readCountsBinned) replaced by their respective relative fractions. Otherwise identical to the input \code{\link{SNPhood}} object.
}
\description{
\code{deleteReadGroups} deletes a particular set of read groups from a \emph{SNPhood} object.
Removal is irreversible. It is therefore recommended to save the resulting \code{\link{SNPhood}} object with a new name.
}
\examples{
data(SNPhood.o, package="SNPhood")
SNPhood_allelicFractions.o = deleteReadGroups(SNPhood.o, "ambiguous")
}
\seealso{
\code{\link{deleteDatasets}}, \code{\link{deleteRegions}}
}

